*** COS 2022 10, recode categorical vars, last update 2023 03  
           
program define dq_dm_brec  
syntax varlist(min=1 numeric), [strata(string) jumpto0recode(int 0)  indent(int 0)]  
local indent=`indent'+5  
local adoname "dq_dm_brec"  
local text_i "di as text _n "  					  
tempvar C_onstant  
qui gen `C_onstant'=1  
foreach var of varlist `varlist' {  
	local pointer "$`var'"  
	local success=0					  
	          
	          
	          
	local ec=0						  
	local rc=0						  
	capture confirm scalar eventcat_$`pointer'  
	if _rc==0 {  
		if "`=eventcat_$`pointer''"~="" {  
			local ec=1  
		}        
	}	        
	capture confirm scalar refcat_$`pointer'  
	if _rc==0  {  
		if "`=eventcat_$`pointer''"~="" {  
			local rc=1  
		}        
	}	        
	if `ec'==1 | `rc'==1  {  
		         
		tempvar recodevar							  
		         
		if `ec'==1 & `rc'==0  {  
			qui gen `recodevar'=0 if m`var'<.  
			capture recode `recodevar' (`=eventcat_$`pointer''=1)	  
			if _rc==0 {  
				lab def l`pointer' 0 "Reference all others" 1 "Event: `=eventcat_$`pointer''"			  
				lab val m`var' l`pointer'	  
				local success=1  
				scalar refcat_`strata'_`pointer'="`=refcat_$`pointer'' vs. $allother_1"					  
			}       
		}        
		if `ec'==0 & `rc'==1  {  
			qui gen `recodevar'=1 if m`var'<.  
			capture recode `recodevar' (`=refcat_$`pointer''=0)	  
			if _rc==0 {  
				lab def l`pointer' 0 "Reference: `=refcat_$`pointer''" 1 "Event all others"				  
				lab val m`var' l`pointer'  
				local success=1  
				scalar refcat_`strata'_`pointer'="$allother_1 vs. `=eventcat_$`pointer'"					  
			}       
		}        
		if `ec'==1 & `rc'==1  {  
			qui capture recode m`var' (`=refcat_$`pointer''=0) (`=eventcat_$`pointer''=1), gen(`recodevar')		  
			if _rc==0 {  
				lab def l`pointer' 0 "Reference: `=refcat_$`pointer''" 1 "Event: `=eventcat_$`pointer''"  
				lab val m`var' l`pointer'			  
				local success=1  
				scalar refcat_`strata'_`pointer'="`=refcat_$`pointer'' vs. `=eventcat_$`pointer''"		  
			}       
		}        
		if `success'==0 {  
			dq_out_add ,  tablename(integtable_metadata) row(integtablerows_metadata) columns(3) colcontent1("$Warning_1") colcontent2("`var' `=refcat_$`pointer''/`=eventcat_$`pointer''") colcontent3($DQ_INT_issue_24)  indent(`indent') 	  
			dq_out_add ,  tablename(integtable_metadata) row(integtablerows_metadata) columns(3) colcontent1("$Action_1")  colcontent2("`var'") colcontent3($DQ_INT_action_24)  indent(`indent') 	  
		}        
		         
		if `success'==1 {  
			tempvar discrepancies  
			qui gen `discrepancies'=1 if m`var' ~= `recodevar'  
			qui count if  `discrepancies'<.  
			scalar changebinaryrecode_`strata'_`pointer'=changebinaryrecode_`strata'_`pointer'+r(N) 	  
			qui replace m`var'=`recodevar'  
			drop `discrepancies'  
			drop `recodevar'			  
		}        
		         
	}         
	if ((`ec'==0 & `rc'==0) | ((`ec'==1 | `rc'==1) & `success'==0 ) ) &strpos( "`=scalelevel_$`pointer''","nominal")>0 {  
	          
		qui tab  m`var', mi  
		         
		*tempvar recodevar  
		*gen `recodevar'=m`var'  
		         
		if `jumpto0recode'==1 {  
			qui recode m`var'(.j=0)  
			scalar changemiss_`strata'_`pointer'=changemiss_`strata'_`pointer'+r(N)  							  
			lab var m`var' "`=varshortlabel_`pointer'' binrecode"  
		}        
		         
		         
		tempvar catcount																				  
		qui egen `catcount'=total(`C_onstant') if m`var'<. , by(m`var')  
		qui tab `catcount'  
		         
		qui sum `catcount' if m`var'==`=vp_min_`strata'_`pointer''  
		if r(N)/`=vp_N_`strata'_`pointer''>.2 scalar refcat_`strata'_`pointer'=`=vp_min_`strata'_`pointer''  
		if r(N)/`=vp_N_`strata'_`pointer''<=.2  {				  
			qui sum `catcount' 										  
			local rmax=r(max)  
			qui sum m`var' if `catcount'==`rmax'					  
			scalar refcat_`strata'_`pointer'=r(mean)  
		}        
		qui recode m`var' (`=refcat_`strata'_`pointer''=-999999)  
		qui recode m`var' (-999999=0) (min/max=1) 					  
		scalar changebinaryrecode_`strata'_`pointer'=changebinaryrecode_`strata'_`pointer'+r(N)  							  
		lab val m`var' binrecodelabel  
		         
		*qui tab m`var' , mi		  
		         
		drop `catcount'  
	}         
		         
} 	        
qui drop `C_onstant'  
end        
